/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

/**
* @date 2019-03-25
*/
//@Entity
@Getter
@Setter
//@Table(name="sys_dept")
@TableName("sys_dept")
public class Dept extends BaseEntity implements Serializable {

    @Id
//    @Column(name = "dept_id")
    @NotNull(groups = Update.class)
    @TableId(value="dept_id", type= IdType.AUTO)
    @ApiModelProperty(value = "ID", hidden = true)
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @TableField(exist = false)
    @JsonIgnore
//    @ManyToMany(mappedBy = "depts")
    @ApiModelProperty(value = "角色")
    private Set<Role> roles;

    @ApiModelProperty(value = "排序")
    @TableField(value = "dept_sort")
    private Integer deptSort;

    @TableField(value = "name")
    @NotBlank
    @ApiModelProperty(value = "部门名称")
    private String name;

    @TableField(value = "enabled")
    @NotNull
    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @TableField(value = "pid")
    @ApiModelProperty(value = "上级部门")
    private Long pid;

    @TableField(value = "sub_count")
    @ApiModelProperty(value = "子节点数目", hidden = true)
    private Integer subCount = 0;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Dept dept = (Dept) o;
        return Objects.equals(id, dept.id) &&
                Objects.equals(name, dept.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name);
    }
}
