/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
* @date 2019-04-10
*/
//@Entity
@Getter
@Setter
//@Table(name="sys_dict_detail")
@TableName("sys_dict_detail")
public class DictDetail extends BaseEntity implements Serializable {

    @Id
//    @Column(name = "detail_id")
    @TableId(value="detail_id", type= IdType.AUTO)
    @NotNull(groups = Update.class)
    @ApiModelProperty(value = "ID", hidden = true)
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @NotNull
    @TableField(value = "dict_id")
    private Long dictId;

    @TableField(exist = false)
//    @JoinColumn(name = "dict_id")
//    @ManyToOne(fetch=FetchType.LAZY)
    @ApiModelProperty(value = "字典", hidden = true)
    private Dict dict;

    @ApiModelProperty(value = "字典标签")
    @TableField(value = "label")
    private String label;

    @ApiModelProperty(value = "小程序字典key")
    @TableField(value = "xcx_key")
    private String xcxKey;

    @ApiModelProperty(value = "字典值")
    @TableField(value = "value")
    private String value;

    @ApiModelProperty(value = "排序")
    @TableField(value = "dict_sort")
    private Integer dictSort = 999;
}
