/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;

/**
* @date 2019-03-29
*/
//@Entity
@Getter
@Setter
//@Table(name="sys_job")
@TableName("sys_job")
public class Job extends BaseEntity implements Serializable {

    @Id
//    @Column(name = "job_id")
    @TableId(value="job_id", type= IdType.AUTO)
    @NotNull(groups = Update.class)
    @ApiModelProperty(value = "ID", hidden = true)
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;


    @ApiModelProperty(value = "岗位名称")
    @TableField(value = "name")
    private String name;

    @ApiModelProperty(value = "岗位编号")
    @TableField(value = "job_serial")
    private String jobSerial;

    @ApiModelProperty(value = "路段id")
    @TableField(value = "parking_road_id")
    private String parkingRoadId;

    @NotBlank
    @ApiModelProperty(value = "路段名称")
    @TableField(value = "parking_road_name")
    private String parkingRoadName;

    @ApiModelProperty(value = "车位数")
    @TableField(value = "parking_num")
    private Integer parkingNum;

//    @NotNull
    @ApiModelProperty(value = "岗位排序")
    @TableField(value = "job_sort")
    private Long jobSort=99L;

    @NotNull
    @ApiModelProperty(value = "是否启用")
    @TableField(value = "enabled")
    private Boolean enabled=true;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job) o;
        return Objects.equals(id, job.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
