package admin.modules.system.domain;

import admin.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 会员数据，小程序登录绑定手机号码用户信息
 * */
//@Entity
@Getter
@Setter
//@Table(name="sys_member")
@TableName("sys_member")
public class Member {
    @Id
//    @Column(name = "member_id")
    @TableId(value="member_id", type= IdType.AUTO)
    @NotNull(groups = BaseEntity.Update.class)
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "ID", hidden = true)
    private Long id;

    @TableField(value = "wx_token")
    @NotBlank
    @ApiModelProperty(value = "微信token")
    private String wxToken;

}
