/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

/**
 * @date 2018-12-17
 */
//@Entity
@Getter
@Setter
//@Table(name = "sys_menu")
@TableName("sys_menu")
public class Menu extends BaseEntity implements Serializable {

    @Id
//    @Column(name = "menu_id")
    @TableId(value="menu_id", type= IdType.AUTO)
    @NotNull(groups = {Update.class})
    @ApiModelProperty(value = "ID", hidden = true)
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @JsonIgnore
//    @ManyToMany(mappedBy = "menus")
    @ApiModelProperty(value = "菜单角色")
    @TableField(exist = false)
    private Set<Role> roles;

    @ApiModelProperty(value = "是否进入导航设置 ")
    @TableField(value = "show_nav")
    private Integer showNav;

    @ApiModelProperty(value = "是否快捷导航")
    @TableField(value = "nav_quick")
    private Integer navQuick;

    @ApiModelProperty(value = "菜单标题")
    @TableField(value = "title")
    private String title;

//    @Column(name = "name")
    @ApiModelProperty(value = "菜单组件名称")
    @TableField(value = "name")
    private String componentName;

    @ApiModelProperty(value = "排序")
    @TableField(value = "menu_sort")
    private Integer menuSort = 999;

    @ApiModelProperty(value = "组件路径")
    @TableField(value = "component")
    private String component;

    @ApiModelProperty(value = "路由地址")
    @TableField(value = "path")
    private String path;

    @ApiModelProperty(value = "菜单类型，目录、菜单、按钮")
    @TableField(value = "type")
    private Integer type;

    @ApiModelProperty(value = "权限标识")
    @TableField(value = "permission")
    private String permission;

    @ApiModelProperty(value = "菜单图标")
    @TableField(value = "icon")
    private String icon;

//    @Column(columnDefinition = "bit(1) default 0")
    @ApiModelProperty(value = "缓存")
    @TableField(value = "cache")
    private Boolean cache;

//    @Column(columnDefinition = "bit(1) default 0")
    @ApiModelProperty(value = "是否隐藏")
    @TableField(value = "hidden")
    private Boolean hidden;

    @ApiModelProperty(value = "上级菜单")
    @TableField(value = "pid")
    private Long pid;

    @ApiModelProperty(value = "子节点数目", hidden = true)
    @TableField(value = "sub_count")
    private Integer subCount = 0;

    @ApiModelProperty(value = "外链菜单")
    @TableField(value = "i_frame")
    private Boolean iFrame;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Menu menu = (Menu) o;
        return Objects.equals(id, menu.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
