/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.utils.DateUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author wl
 * @website https://el-admin.vip
 * @description /
 * @date 2020-07-12
 **/
//@Entity
@Data
//@Table(name="sys_user_arrange_detail")
@TableName("sys_user_arrange_detail")
public class SysUserArrangeDetail implements Serializable {

    @Id
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
//    @Column(name = "arrange_detail_id")
    @TableId(value = "arrange_detail_id", type = IdType.AUTO)
    @ApiModelProperty(value = "arrangeDetailId")
    private Long arrangeDetailId;

    //    @Column(name = "arrange_id")
    @TableField(value = "arrange_id")
    @ApiModelProperty(value = "排班id")
    private Long arrangeId;

    //    @Column(name = "arrange_name")
    @TableField(value = "arrange_name")
    @ApiModelProperty(value = "排班")
    private String arrangeName;

    //    @Column(name = "road_id")
    @TableField(value = "road_id")
    @ApiModelProperty(value = "路段id")
    private Long roadId;

    //    @Column(name = "job_id")
    @TableField(value = "job_id")
    @ApiModelProperty(value = "岗位id")
    private Long jobId;

    @TableField(value = "job_serial")
    @ApiModelProperty(value = "岗位编号")
    private String jobSerial;

    //    @Column(name = "user_id")
    @TableField(value = "user_id")
    @ApiModelProperty(value = "上岗人id")
    private Long userId;

    //    @Column(name = "transfer_id")
    @TableField(value = "transfer_id")
    @ApiModelProperty(value = "调岗人id")
    private Long transferId;

    //    @Column(name = "is_extra_work")
    @TableField(value = "is_extra_work")
    @ApiModelProperty(value = "是否加班 1：否，2：是")
    private Integer isExtraWork = 1;

    //    @Column(name = "create_time")
    @TableField(value = "create_time")
    @ApiModelProperty(value = "创建时间")
    private Timestamp createTime = DateUtil.getNowTimestamp();

    @ApiModelProperty(value = "备注")
    @TableField(value = "note")
    private String note;

    //    @Column(name = "road_name")
    @TableField(value = "road_name")
    @ApiModelProperty(value = "路段名称")
    private String roadName;

    //    @Column(name = "job_name")
    @TableField(value = "job_name")
    @ApiModelProperty(value = "岗位名称")
    private String jobName;

    //    @Column(name = "user_name")
    @TableField(value = "user_name")
    @ApiModelProperty(value = "上岗人名称")
    private String userName;

    //    @Column(name = "transfer_name")
    @TableField(value = "transfer_name")
    @ApiModelProperty(value = "调岗人名称")
    private String transferName;

    public void copy(SysUserArrangeDetail source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
