/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.utils.DateUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DatePattern;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author wl
 * @website https://el-admin.vip
 * @description /
 * @date 2020-07-12
 **/
//@Entity
@Data
@TableName("sys_user_arrange_info")
public class SysUserArrangeInfo implements Serializable {

    @Id
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
//    @Column(name = "arrange_id")
    @TableId(value = "arrange_id", type = IdType.AUTO)
    @ApiModelProperty(value = "主键")
    private Long arrangeId;

    //    @Column(name = "arrange_day")
    @TableField(value = "arrange_day")
    @ApiModelProperty(value = "排班日期")
    private String arrangeDay = DateUtil.timestampFormat(DateUtil.getNowTimestamp(), DatePattern.NORM_DATE_PATTERN);

    //    @Column(name = "used_road_num")
    @TableField(value = "used_road_num")
    @ApiModelProperty(value = "已排路段数")
    private Integer usedRoadNum = 0;

    //    @Column(name = "used_job_num")
    @TableField(value = "used_job_num")
    @ApiModelProperty(value = "已排岗位数")
    private Integer usedJobNum = 0;

    //    @Column(name = "used_user_num")
    @TableField(value = "used_user_num")
    @ApiModelProperty(value = "上岗人数")
    private Integer usedUserNum = 0;

    //    @Column(name = "op_user_name")
    @TableField(value = "op_user_name")
    @ApiModelProperty(value = "排班人")
    private String opUserName;

    //    @Column(name = "create_time")
    @TableField(value = "create_time")
    @ApiModelProperty(value = "创建时间")
    private Timestamp createTime = DateUtil.getNowTimestamp();

    public void copy(SysUserArrangeInfo source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
