/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * @author wl
 * @website https://el-admin.vip
 * @description /
 * @date 2020-09-16
 **/
//@Entity
@Data
//@Table(name="sys_user_charge")
@TableName("sys_user_charge")
public class SysUserCharge implements Serializable {

    @Id
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
//    @Column(name = "charge_id")
    @TableId(value = "charge_id", type = IdType.AUTO)
    @ApiModelProperty(value = "主键")
    private Long chargeId;

    //    @Column(name = "user_id")
    @TableField(value = "user_id")
    @ApiModelProperty(value = "用户id")
    private Long userId;

    //    @Column(name = "phone")
    @TableField(value = "phone")
    @ApiModelProperty(value = "电话号码")
    private String phone;

    //    @Column(name = "user_name")
    @TableField(value = "user_name")
    @ApiModelProperty(value = "用户名")
    private String userName;

    //    @Column(name = "charge_amount")
    @TableField(value = "charge_amount")
    @ApiModelProperty(value = "充值金额")
    private BigDecimal chargeAmount;

    //    @Column(name = "before_amount")
    @TableField(value = "before_amount")
    @ApiModelProperty(value = "充值前金额")
    private BigDecimal beforeAmount;

    //    @Column(name = "after_amount")
    @TableField(value = "after_amount")
    @ApiModelProperty(value = "充值后余额")
    private BigDecimal afterAmount;

    //    @Column(name = "op_name")
    @TableField(value = "op_name")
    @ApiModelProperty(value = "操作人")
    private String opName;

    //    @Column(name = "create_time")
    @TableField(value = "create_time")
    @ApiModelProperty(value = "充值时间")
    private Timestamp createTime;

    public void copy(SysUserCharge source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
