/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.utils.DateUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author wl
 * @website https://el-admin.vip
 * @description /
 * @date 2020-07-15
 **/
//@Entity
@Data
//@Table(name="sys_user_notice")
@TableName("sys_user_notice")
public class SysUserNotice implements Serializable {

    @Id
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
//    @Column(name = "notice_id")
    @TableId(value = "notice_id", type = IdType.AUTO)
    @ApiModelProperty(value = "主键")
    private Long noticeId;

    //    @Column(name = "notice_type")
    @TableField(value = "notice_type")
    @ApiModelProperty(value = "通知类型：1通知2代办3警告")
    private Integer noticeType = 1;

    //    @Column(name = "sub_type")
    @TableField(value = "sub_type")
    @ApiModelProperty(value = "通知类型：1:入场，2：出场 10:入场超时，20:出场超时 30:支付超时，40：未修改车牌超时 100:超时未补拍 200:支付离场通知，210：跳费待办 300:车位异常 310:车位异常完成")
    private Integer subType = 1;

    //    @Column(name = "is_read")
    @TableField(value = "is_read")
    @ApiModelProperty(value = "是否已读 1：未读，2：已读")
    private Integer isRead = 1;

    //    @Column(name = "dev_id")
    @TableField(value = "dev_id")
    @ApiModelProperty(value = "设备id")
    private Long devId;

    //    @Column(name = "job_id")
    @TableField(value = "job_id")
    @ApiModelProperty(value = "岗位id")
    private Long jobId;

    //    @Column(name = "plate_id")
    @TableField(value = "plate_id")
    @ApiModelProperty(value = "车牌id")
    private Long plateId;

    //    @Column(name = "is_black")
    @TableField(value = "is_black")
    @ApiModelProperty(value = "是否黑车  1：是，2：否")
    private Integer isBlack;

    //    @Column(name = "parking_id")
    @TableField(value = "parking_id")
    @ApiModelProperty(value = "车位id")
    private Long parkingId;

    //    @Column(name = "msg")
    @TableField(value = "msg")
    @ApiModelProperty(value = "消息内容")
    private String msg;

    //    @Column(name = "create_time")
    @TableField(value = "create_time")
    @ApiModelProperty(value = "创建时间")
    private Timestamp createTime = DateUtil.getNowTimestamp();

    public void copy(SysUserNotice source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
