/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.utils.DateUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author wl
 * @website https://el-admin.vip
 * @description /
 * @date 2020-07-19
 **/
//@Entity
@Data
//@Table(name="system_op_log")
@TableName("system_op_log")
public class SystemOpLog implements Serializable {

    @Id
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
//    @Column(name = "system_op_log_id")
    @TableId(value = "system_op_log_id", type = IdType.AUTO)
    @ApiModelProperty(value = "主键")
    private Long systemOpLogId;

    //    @Column(name = "order_id")
    @TableField(value = "order_id")
    @ApiModelProperty(value = "订单id")
    private Long orderId;

    //    @Column(name = "user_id")
    @TableField(value = "user_id")
    @ApiModelProperty(value = "操作人id")
    private Long userId;

    //    @Column(name = "user_name")
    @TableField(value = "user_name")
    @ApiModelProperty(value = "操作人")
    private String userName;

    //    @Column(name = "log_msg")
    @TableField(value = "log_msg")
    @ApiModelProperty(value = "日志内容")
    private String logMsg;

    //    @Column(name = "create_time")
    @TableField(value = "create_time")
    @ApiModelProperty(value = "创建时间")
    private Timestamp createTime = DateUtil.getNowTimestamp();

    public void copy(SystemOpLog source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
