/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.utils.DateUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * @author wl
 * @website https://el-admin.vip
 * @description /
 * @date 2020-07-12
 **/
//@Entity
@Data
//@Table(name="system_user_work")
@TableName("system_user_work")
public class SystemUserWork implements Serializable {

    @Id
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
//    @Column(name = "work_id")
    @TableId(value = "work_id", type = IdType.AUTO)
    @ApiModelProperty(value = "workId")
    private Long workId;

    //    @Column(name = "user_id")
    @TableField(value = "user_id")
    @ApiModelProperty(value = "userId")
    private Long userId;

    //    @Column(name = "user_name")
    @TableField(value = "user_name")
    @ApiModelProperty(value = "姓名")
    private String userName;

    //    @Column(name = "status")
    @TableField(value = "status")
    @ApiModelProperty(value = "状态：1正常，2：异常 3迟到")
    private Integer status = 1;

    //    @Column(name = "is_extra_work")
    @TableField(value = "is_extra_work")
    @ApiModelProperty(value = "是否加班 1：否，2：是")
    private Integer isExtraWork = 1;

    //    @Column(name = "road_id")
    @TableField(value = "road_id")
    @ApiModelProperty(value = "roadId")
    private Long roadId;

    //    @Column(name = "road_name")
    @TableField(value = "road_name")
    @ApiModelProperty(value = "路段")
    private String roadName;

    //    @Column(name = "job_id")
    @TableField(value = "job_id")
    @ApiModelProperty(value = "jobId")
    private Long jobId;

    //    @Column(name = "job_name")
    @TableField(value = "job_name")
    @ApiModelProperty(value = "岗位名称")
    private String jobName;

    //    @Column(name = "start_time")
    @TableField(value = "start_time")
    @ApiModelProperty(value = "打卡时间")
    private Timestamp startTime = DateUtil.getNowTimestamp();

    //    @Column(name = "end_time")
    @TableField(value = "end_time")
    @ApiModelProperty(value = "下班时间")
    private Timestamp endTime;

    //    @Column(name = "work_time")
    @TableField(value = "work_time")
    @ApiModelProperty(value = "工作时间")
    private BigDecimal workTime = BigDecimal.ZERO;

    //    @Column(name = "create_time")
    @TableField(value = "create_time")
    @ApiModelProperty(value = "createTime")
    private Timestamp createTime = DateUtil.getNowTimestamp();

    @TableField(value = "is_business")
    @ApiModelProperty(value = "是否业务员 1:业务员，2:管理员" )
    private Integer isBusiness = 0;
    public void copy(SystemUserWork source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
