/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.domain;

import admin.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @date 2018-11-22
 */
//@Entity
@Getter
@Setter
//@Table(name="sys_user")
@TableName("sys_user")
public class UserSystem extends BaseEntity implements Serializable {

    @Id
//    @Column(name = "user_id")
    @TableId(value = "user_id", type = IdType.AUTO)
    @NotNull(groups = Update.class)
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "ID", hidden = true)
    private Long id;

    @TableField(value = "username")
    @NotBlank
//    @Column(unique = true)
    @ApiModelProperty(value = "用户名称")
    private String username;

    @TableField(value = "nick_name")
//    @NotBlank
    @ApiModelProperty(value = "用户昵称")
    private String nickName;

    @TableField(value = "user_serial")
    @ApiModelProperty(value = "用户编号")
    private String userSerial;

    @TableField(value = "amount")
    @ApiModelProperty(value = "账户余额")
    private BigDecimal amount = BigDecimal.ZERO;

    @TableField(value = "is_business")
    @ApiModelProperty(value = "是否业务员")
    private Integer isBusiness = 0;

    //    @Column(name="job_id")
    @TableField(value = "job_id")
    @ApiModelProperty(value = "收费员上岗id")
    private Long jobId;

    //    @Column
    @TableField(value = "email")
    @ApiModelProperty(value = "邮箱")
    private String email;

    //    @Column
    @TableField(value = "phone")
    @NotBlank
    @ApiModelProperty(value = "电话号码")
    private String phone;

    @TableField(value = "identity_card")
    @ApiModelProperty(value = "身份证号码")
    private String identityCard;

    @TableField(value = "gender")
    @ApiModelProperty(value = "用户性别")
    private String gender;

    @TableField(value = "avatar_name")
    @ApiModelProperty(value = "头像真实名称", hidden = true)
    private String avatarName;

    @TableField(value = "avatar_path")
    @ApiModelProperty(value = "头像存储的路径", hidden = true)
    private String avatarPath;

    @TableField(value = "password")
    @ApiModelProperty(value = "密码")
    private String password;

    @TableField(value = "enabled")
    @NotNull
    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @TableField(value = "is_admin")
    @ApiModelProperty(value = "是否为admin账号", hidden = true)
    private Boolean isAdmin = false;

    //    @Column(name = "pwd_reset_time")
    @TableField(value = "pwd_reset_time")
    @ApiModelProperty(value = "最后修改密码的时间", hidden = true)
    private Date pwdResetTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserSystem user = (UserSystem) o;
        return Objects.equals(id, user.id) &&
                Objects.equals(username, user.username);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, username);
    }
}
