/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.system.domain.DictDetail;
import admin.modules.system.service.dto.DictDetailDto;
import admin.modules.system.service.dto.DictDetailQueryCriteria;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
* @date 2019-04-10
*/
public interface DictDetailService extends CommonService<DictDetail> {

    /**
     * 创建
     * @param resources /
     */
    void create(DictDetail resources);

    /**
     * 编辑
     * @param resources /
     */
    void update(DictDetail resources);

    /**
     * 删除
     * @param id /
     */
    void delete(Long id);

    /**
     * 分页查询
     * @param criteria 条件
     * @param pageable 分页参数
     * @return PageInfo<DictDetailDto>
     */
    PageInfo<DictDetailDto> queryAll(DictDetailQueryCriteria criteria, Pageable pageable);

    /**
     * 查询所有数据不分页
     * @param query 条件参数
     * @return List<DictDetailDto>
     */
    List<DictDetailDto> queryAll(DictDetailQueryCriteria query);

    /**
     * 根据字典名称获取字典详情
     * @param name 字典名称
     * @return /
     */
    List<DictDetailDto> getDictByName(String name);

    /**
     * 一键添加小程序字典
     * @param json
     * @return /
     */
    void addAll(String json);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    DictDetailDto findById(Long id);

    /**
     * 获取小程序字典
     * @return /
     */
    Map<String,Object> getXcx();

    DictDetail getDictByNameOne(String label);
}
