/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.system.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.system.domain.SysContent;
import admin.modules.system.service.dto.SysContentDto;
import admin.modules.system.service.dto.SysContentQueryCriteria;
import org.springframework.data.domain.Pageable;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
* @website https://el-admin.vip
* @description 服务接口
* @author lj
* @date 2023-06-01
**/
public interface SysContentService extends CommonService<SysContent> {

    /**
    * 查询数据分页
    * @param criteria 条件
    * @param pageable 分页参数
    * @return PageInfo<SysContentDto>
    */
    PageInfo<SysContentDto> queryAll(SysContentQueryCriteria criteria, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param criteria 条件参数
    * @return List<SysContentDto>
    */
    List<SysContentDto> queryAll(SysContentQueryCriteria criteria);

    /**
     * 根据ID查询
     * @param contentId ID
     * @return SysContentDto
     */
    SysContentDto findById(Long contentId);

    /**
    * 创建
    * @param resources /
    * @return SysContentDto
    */
    SysContentDto create(SysContent resources);

    /**
    * 编辑
    * @param resources /
    */
    void update(SysContent resources);

    /**
    * 多选删除
    * @param ids /
    */
    void deleteAll(Long[] ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<SysContentDto> all, HttpServletResponse response) throws IOException;
}
