/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.system.service;

import admin.base.CommonService;
import admin.base.PageInfo;
import admin.modules.system.domain.SystemOpLog;
import admin.modules.system.service.dto.SystemOpLogDto;
import admin.modules.system.service.dto.SystemOpLogQueryCriteria;
import org.springframework.data.domain.Pageable;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
* @website https://el-admin.vip
* @description 服务接口
* @author wl
* @date 2020-07-19
**/
public interface SystemOpLogService extends CommonService<SystemOpLog> {
    /**
     * 未登录用户的系统日志
     * */
    void insertSystemOpLogUnLogin(Long orderId,String msg,String userName);
    /**
    * 查询数据分页
    * @param criteria 条件
    * @param pageable 分页参数
    * @return PageInfo<SystemOpLogDto>
    */
    PageInfo<SystemOpLogDto> queryAll(SystemOpLogQueryCriteria criteria, Pageable pageable);

    /**
    * 查询所有数据不分页
    * @param criteria 条件参数
    * @return List<SystemOpLogDto>
    */
    List<SystemOpLogDto> queryAll(SystemOpLogQueryCriteria criteria);

    /**
     * 根据ID查询
     * @param systemOpLogId ID
     * @return SystemOpLogDto
     */
    SystemOpLogDto findById(Long systemOpLogId);

    /**
    * 创建
    * @param resources /
    * @return SystemOpLogDto
    */
    SystemOpLogDto create(SystemOpLog resources);

    /**
    * 编辑
    * @param resources /
    */
    void update(SystemOpLog resources);

    /**
    * 多选删除
    * @param ids /
    */
    void deleteAll(Long[] ids);

    /**
    * 导出数据
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<SystemOpLogDto> all, HttpServletResponse response) throws IOException;
}
