/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.system.service.dto;

import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
* @website https://el-admin.vip
* @description /
* @author wl
* @date 2020-07-12
**/
@Data
public class SysUserArrangeDetailDto implements Serializable {

    private Long arrangeDetailId;

    /** 排班id */
    private Long arrangeId;
    private String arrangeName;

    /** 路段id */
    private Long roadId;

    /** 岗位id */
    private Long jobId;

    /** 岗位编号 */
    private String jobSerial;

    /** 上岗人id */
    private Long userId;

    /** 调岗人id */
    private Long transferId;

    /** 是否加班 1：否，2：是 */
    private Integer isExtraWork;

    /** 创建时间 */
    private Timestamp createTime;

    /** 备注 */
    private String note;

    /** 路段名称 */
    private String roadName;

    /** 岗位名称 */
    private String jobName;

    /** 上岗人名称 */
    private String userName;

    /** 调岗人名称 */
    private String transferName;
}
