/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.system.service.dto;

import admin.annotation.Query;
import lombok.Data;

import java.sql.Timestamp;
import java.util.List;

/**
* @website https://el-admin.vip
* @author wl
* @date 2020-07-12
**/
@Data
public class SysUserArrangeDetailQueryCriteria{

    /** 精确 */
    @Query
    private Integer isExtraWork;
    @Query(type = Query.Type.INNER_LIKE)
    private String arrangeName;
    @Query
    private Long arrangeId;

    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String note;

    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String roadName;

    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String jobName;

    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String userName;

    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String transferName;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<Timestamp> createTime;
}
