/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.system.service.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
* @website https://el-admin.vip
* @description /
* @author wl
* @date 2020-09-16
**/
@Data
public class SysUserChargeDto implements Serializable {

    /** 主键 */
    private Long chargeId;

    /** 用户id */
    private Long userId;

    /** 电话号码 */
    private String phone;

    /** 用户名 */
    private String userName;

    /** 充值金额 */
    private BigDecimal chargeAmount;

    /** 充值前金额 */
    private BigDecimal beforeAmount;

    /** 充值后余额 */
    private BigDecimal afterAmount;

    /** 操作人 */
    private String opName;

    /** 充值时间 */
    private Timestamp createTime;
}
