/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.system.service.dto;

import lombok.Data;

import java.sql.Timestamp;

/**
* @website https://el-admin.vip
* @description /
* @author wl
* @date 2020-07-15
**/
@Data
public class SysUserNoticeDto {

    /** 主键 */
    private Long noticeId;

    /** 通知类型：1通知2代办3警告 */
    private Integer noticeType;
    /**子类型，1:入场，2：出场*/
    private Integer subType;
    /** 是否已读 1：未读，2：已读 */
    private Integer isRead;
    /**车牌id*/
    private Long plateId;
    /**
     * 岗位id
     * */
    private Long jobId;
    /**
     * 设备id
     * */
    private Long devId;

    /** 是否黑车  1：是，2：否 */
    private Integer isBlack;
    /**
     * 车位id
     * */
    private Long parkingId;
    /**消息内容*/
    private String msg;

    /** 创建时间 */
    private Timestamp createTime;
}
