/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.modules.system.service.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
* @website https://el-admin.vip
* @description /
* @author wl
* @date 2020-07-12
**/
@Data
public class SystemUserWorkDto implements Serializable {

    private Long workId;

    private Long userId;

    /** 姓名 */
    private String userName;

    /** 状态：1正常，2：异常 3迟到 */
    private Integer status;

    /** 是否加班 */
    private Integer isExtraWork;

    private Long roadId;

    /** 路段 */
    private String roadName;

    private Long jobId;

    /** 岗位名称 */
    private String jobName;

    /** 打卡时间 */
    private Timestamp startTime;

    /** 下班时间 */
    private Timestamp endTime;

    /** 工作时间 */
    private BigDecimal workTime;

    private Timestamp createTime;
    private Integer isBusiness = 0;
}
