/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.service.dto;

import admin.annotation.Query;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 业务员，收费员查询
 */
@Data
public class UserInfoQueryCriteria implements Serializable {

    @Query
    private Long id;
    @Query
    private Integer enabled;
    @Query
    private Integer isBusiness;
    @Query(type = Query.Type.IN,propName = "isBusiness")
    private Set<Integer> inBusiness;
    @Query(type = Query.Type.IN)
    private Set<Integer> jobId;
    @Query(blurry = "email,username,nickName,phone,userSerial")
    private String blurry;
}
