/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package admin.modules.system.service.impl;

import admin.annotation.CurDataSource;
import admin.base.PageInfo;
import admin.base.QueryHelpMybatisPlus;
import admin.base.impl.CommonServiceImpl;
import admin.modules.system.domain.Job;
import admin.modules.system.service.JobService;
import admin.modules.system.service.dto.JobDto;
import admin.modules.system.service.dto.JobQueryCriteria;
import admin.modules.system.service.mapper.JobMapper;
import admin.utils.ConvertUtil;
import admin.utils.PageUtil;
import admin.utils.ValidationUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
* @date 2019-03-29
*/
@Service
@CurDataSource("slaver")
@RequiredArgsConstructor
@CacheConfig(cacheNames = "job")
@Slf4j
public class JobServiceImpl extends CommonServiceImpl<JobMapper, Job> implements JobService {

    private final JobMapper jobMapper;

    @Override
    public PageInfo<JobDto> queryAll(JobQueryCriteria criteria, Pageable pageable) {
        IPage<Job> page = PageUtil.toMybatisPage(pageable, false);
        IPage<Job> pageList = jobMapper.selectPage(page, QueryHelpMybatisPlus.getPredicate(criteria));
        return ConvertUtil.convertPage(pageList, JobDto.class);
    }

    @Override
    public List<JobDto> queryAll(JobQueryCriteria criteria) {
        List<Job> list = jobMapper.selectList(QueryHelpMybatisPlus.getPredicate(criteria));
        return ConvertUtil.convertList(list, JobDto.class);
    }

    @Override
    @Cacheable(key = "'id:' + #p0")
    public JobDto findById(Long id) {
        Job job = jobMapper.selectById(id);
        ValidationUtil.isNull(job.getId(),"Job","id",id);
        return ConvertUtil.convert(job, JobDto.class);
    }

}
