package admin.modules.system.service.impl;

import admin.base.impl.CommonServiceImpl;
import admin.modules.system.domain.SysRolesDepts;
import admin.modules.system.service.SysRolesDeptsService;
import admin.modules.system.service.mapper.SysRolesDeptsMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @description: SysRolesDeptsServiceImpl
 * @date: 2023/7/28 10:06
 * @author: wk
 * @version: 1.0
 */
@AllArgsConstructor
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class SysRolesDeptsServiceImpl extends CommonServiceImpl<SysRolesDeptsMapper, SysRolesDepts> implements SysRolesDeptsService {
    @Override
    public List<Long> queryDeptIdByRoleId(Long id) {
        return lambdaQuery().eq(SysRolesDepts::getRoleId, id).list().stream().map(SysRolesDepts::getDeptId)
                .collect(Collectors.toList());
    }

    @Override
    public List<Long> queryRoleIdByDeptId(Long id) {
        return lambdaQuery().eq(SysRolesDepts::getDeptId, id).list().stream().map(SysRolesDepts::getRoleId)
                .collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeByRoleId(Long id) {
        return lambdaUpdate().eq(SysRolesDepts::getRoleId, id).remove();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeByDeptId(Long id) {
        return lambdaUpdate().eq(SysRolesDepts::getDeptId, id).remove();
    }
}
