package admin.modules.system.service.impl;

import admin.base.impl.CommonServiceImpl;
import admin.modules.system.domain.SysRolesMenus;
import admin.modules.system.service.SysRolesMenusService;
import admin.modules.system.service.mapper.SysRolesMenusMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @description: SysRolesMenusServiceImpl
 * @date: 2023/7/28 10:21
 * @author: wk
 * @version: 1.0
 */
@AllArgsConstructor
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class SysRolesMenusServiceImpl extends CommonServiceImpl<SysRolesMenusMapper, SysRolesMenus> implements SysRolesMenusService {

    @Override
    public List<Long> queryMenuIdByRoleId(Long id) {
        return lambdaQuery().eq(SysRolesMenus::getRoleId, id).list().stream().map(SysRolesMenus::getMenuId)
                .collect(Collectors.toList());
    }

    @Override
    public List<Long> queryRoleIdByMenuId(Long id) {
        return lambdaQuery().eq(SysRolesMenus::getMenuId, id).list().stream().map(SysRolesMenus::getRoleId)
                .collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeByRoleId(Long id) {
        return lambdaUpdate().eq(SysRolesMenus::getRoleId, id).remove();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeByMenuId(Long id) {
        return lambdaUpdate().eq(SysRolesMenus::getMenuId, id).remove();
    }
}
