package admin.modules.system.service.impl;

import admin.base.impl.CommonServiceImpl;
import admin.modules.system.domain.SysUsersRoles;
import admin.modules.system.service.SysUsersRolesService;
import admin.modules.system.service.mapper.SysUsersRolesMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: SysUsersRolesServiceImpl
 * @date: 2023/7/28 10:44
 * @author: wk
 * @version: 1.0
 */
@AllArgsConstructor
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class SysUsersRolesServiceImpl extends CommonServiceImpl<SysUsersRolesMapper, SysUsersRoles> implements SysUsersRolesService {

    private SysUsersRolesMapper sysUsersRolesMapper;

    @Override
    public void deleteByUserId(Long id) {
        sysUsersRolesMapper.deleteByUserId(id);
    }
}
