package admin.modules.system.service.mapper;

import admin.base.CommonMapper;
import admin.modules.system.domain.Dept;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;


/**
 * @description: DeptMapper
 * @date: 2023/7/24 17:24
 * @author: wk
 * @version: 1.0
 */
@Repository
public interface DeptMapper extends CommonMapper<Dept> {

    /**
     * 根据 PID 查询
     * @param id pid
     * @return /
     */
    List<Dept> findByPid(@Param("id") Long id);

    /**
     * 获取顶级部门
     * @return /
     */
    List<Dept> findByPidIsNull();

    /**
     * 根据角色ID 查询
     * @param roleId 角色ID
     * @return /
     */
    Set<Dept> findByRoleId(@Param("roleId") Long roleId);

    /**
     * 判断是否存在子节点
     * @param pid /
     * @return /
     */
    int countByPid(Long pid);

    /**
     * 根据ID更新sub_count
     * @param count /
     * @param id /
     */
    void updateSubCntById(@Param("count") Integer count,
                          @Param("id") Long id);
}
