package admin.modules.system.service.mapper;

import admin.base.CommonMapper;
import admin.modules.system.domain.Menu;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * @description: MenuMapper
 * @date: 2023/7/24 17:27
 * @author: wk
 * @version: 1.0
 */
@Repository
public interface MenuMapper extends CommonMapper<Menu> {

    /**
     * 根据菜单标题查询
     * @param title 菜单标题
     * @return /
     */
    Menu findByTitle(@Param("title") String title);

    /**
     * 根据组件名称查询
     * @param name 组件名称
     * @return /
     */
    Menu findByComponentName(@Param("name") String name);

    /**
     * 根据菜单的 PID 查询
     * @param pid /
     * @return /
     */
    List<Menu> findByPid(@Param("pid") long pid);

    /**
     * 查询顶级菜单
     * @return /
     */
    List<Menu> findByPidIsNull();

    /**
     * 根据角色ID与菜单类型查询菜单
     * @param roleIds roleIDs
     * @param type 类型
     * @return /
     */
    LinkedHashSet<Menu> findByRoleIdsAndTypeNot(@Param("roleIds") Set<Long> roleIds,
                                                @Param("type") int type);

    /**
     * 获取节点数量
     * @param id /
     * @return /
     */
    int countByPid(@Param("id") Long id);

    /**
     * 更新节点数目
     * @param count /
     * @param menuId /
     */
    void updateSubCntById(@Param("count") int count,
                          @Param("menuId") Long menuId);

    /**
     * 清空所有快捷方式
     */
    void delQuick();

    /**
     * 添加快捷方式
     */
    void addQuick(@Param("ids") Set<Long> ids);

    /**
     * 根据角色ID查询菜单
     * @param roleId
     * @return
     */
    Set<Menu> findMenuByRoleId(@Param("roleId") Long roleId);
}
