package admin.modules.system.service.mapper;

import admin.base.CommonMapper;
import admin.modules.system.domain.Role;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * @description: RoleMapper
 * @date: 2023/7/24 17:28
 * @author: wk
 * @version: 1.0
 */
@Repository
public interface RoleMapper extends CommonMapper<Role> {

    /**
     * 根据名称查询
     * @param name /
     * @return /
     */
    Role findByName(@Param("name") String name);

    /**
     * 删除多个角色
     * @param ids /
     */
    void deleteAllByIdIn(@Param("ids") Set<Long> ids);

    /**
     * 根据用户ID查询
     * @param id 用户ID
     * @return /
     */
    Set<Role> findByUserId(@Param("id") Long id);

    /**
     * 解绑角色菜单
     * @param id 菜单ID
     */
    void untiedMenu(@Param("id") Long id);

    /**
     * 根据部门查询
     * @param deptIds /
     * @return /
     */
    int countByDepts(@Param("deptIds") Set<Long> deptIds);

    /**
     * 根据菜单Id查询
     * @param menuIds /
     * @return /
     */
    List<Role> findInMenuId(@Param("menuIds") List<Long> menuIds);
}
