package admin.modules.system.service.mapper;

import admin.base.CommonMapper;
import admin.modules.system.domain.User;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @description: UserMapper
 * @date: 2023/7/24 17:32
 * @author: wk
 * @version: 1.0
 */
@Repository
public interface UserMapper extends CommonMapper<User> {

    /**
     * 根据用户名查询
     * @param username 用户名
     * @return /
     */
    User findByUsername(@Param("username") String username);
    /**
     * 根据邮箱查询
     * @param email 邮箱
     * @return /
     */
    User findByEmail(@Param("email") String email);

    User findByPhone(@Param("phone") String phone);
    User findByJobId(@Param("jobId") Long jobId);
    List<User> findListByJobId(@Param("jobId") Long jobId);

    User findUserByIdNoAuth(@Param("userId") Long userId);
//    @Query(value = "update sys_user set amount=?2 where user_id = ?1 ",nativeQuery = true)
//    void updateUserAmount(Long userId,BigDecimal amount);
    /**
     * 修改密码
     * @param username 用户名
     * @param pass 密码
     * @param lastPasswordResetTime /
     */
    void updatePass(@Param("username") String username,
                    @Param("pass") String pass,
                    @Param("lastPasswordResetTime") Date lastPasswordResetTime);

    /**
     * 修改邮箱
     * @param username 用户名
     * @param email 邮箱
     */
    void updateEmail(@Param("username") String username,
                     @Param("email") String email);

    /**
     * 根据角色查询用户
     * @param roleId /
     * @return /
     */
    List<User> findByRoleId(@Param("roleId") Long roleId);

    /**
     * 根据角色中的部门查询
     * @param id /
     * @return /
     */
    List<User> findByDeptRoleId(@Param("id") Long id);

    /**
     * 根据菜单查询
     * @param id 菜单ID
     * @return /
     */
    List<User> findByMenuId(@Param("id") Long id);

    /**
     * 根据Id删除
     * @param ids /
     */
    void deleteAllByIdIn(@Param("ids") Set<Long> ids);

    /**
     * 根据岗位查询
     * @param ids /
     * @return /
     */
    int countByJobs(@Param("ids") Set<Long> ids);

    /**
     * 根据部门查询
     * @param deptIds /
     * @return /
     */
    int countByDepts(@Param("deptIds") Set<Long> deptIds);

    /**
     * 根据角色查询
     * @param ids /
     * @return /
     */
    int countByRoles(@Param("ids") Set<Long> ids);

    @Transactional
    void updateUserAmount(@Param("userId") Long userId,
                          @Param("amount") BigDecimal amount);

    List<User> allUsers();

    List<Map<String,Object>> allUserData();
}
