/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.rest;


import admin.annotation.Log;
import admin.modules.system.domain.SysContent;
import admin.modules.system.service.SysContentService;
import admin.modules.system.service.dto.SysContentQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
* @website https://el-admin.vip
* @author lj
* @date 2023-06-01
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "SysContentService管理")
@RequestMapping("/api/sysContent")
public class SysContentController {

    private final SysContentService sysContentService;

    @Log("导出数据")
    @ApiOperation("导出数据")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('sysContent:list')")
    public void download(HttpServletResponse response, SysContentQueryCriteria criteria) throws IOException {
        sysContentService.download(sysContentService.queryAll(criteria), response);
    }

    @GetMapping
    @Log("查询SysContentService")
    @ApiOperation("查询SysContentService")
    @PreAuthorize("@el.check('sysContent:list')")
    public ResponseEntity<Object> query(SysContentQueryCriteria criteria, Pageable pageable){
        return new ResponseEntity<>(sysContentService.queryAll(criteria,pageable),HttpStatus.OK);
    }

    @PostMapping
    @Log("新增SysContentService")
    @ApiOperation("新增SysContentService")
    @PreAuthorize("@el.check('sysContent:add')")
    public ResponseEntity<Object> create(@Validated @RequestBody SysContent resources){
        return new ResponseEntity<>(sysContentService.create(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改SysContentService")
    @ApiOperation("修改SysContentService")
    @PreAuthorize("@el.check('sysContent:edit')")
    public ResponseEntity<Object> update(@Validated @RequestBody SysContent resources){
        sysContentService.update(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @Log("删除SysContentService")
    @ApiOperation("删除SysContentService")
    @PreAuthorize("@el.check('sysContent:del')")
    @DeleteMapping
    public ResponseEntity<Object> delete(@RequestBody Long[] ids) {
        sysContentService.deleteAll(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }
}
