/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.rest;


import admin.annotation.Log;
import admin.modules.system.domain.SysUserNotice;
import admin.modules.system.service.SysUserNoticeService;
import admin.modules.system.service.dto.SysUserNoticeQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
* @website https://el-admin.vip
* @author wl
* @date 2020-07-15
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "UserNoticeService管理")
@RequestMapping("/api/sysUserNotice")
public class SysUserNoticeController {

    private final SysUserNoticeService sysUserNoticeService;

    @Log("导出数据")
    @ApiOperation("导出数据")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('sysUserNotice:list')")
    public void download(HttpServletResponse response, SysUserNoticeQueryCriteria criteria) throws IOException {
        sysUserNoticeService.download(sysUserNoticeService.queryAll(criteria), response);
    }

    @GetMapping
    @ApiOperation("查询UserNoticeService")
    @PreAuthorize("@el.check('sysUserNotice:list')")
    public ResponseEntity<Object> query(SysUserNoticeQueryCriteria criteria, Pageable pageable){
        return new ResponseEntity<>(sysUserNoticeService.queryAll(criteria,pageable),HttpStatus.OK);
    }

    @PostMapping
    @Log("新增UserNoticeService")
    @ApiOperation("新增UserNoticeService")
    @PreAuthorize("@el.check('sysUserNotice:add')")
    public ResponseEntity<Object> create(@Validated @RequestBody SysUserNotice resources){
        return new ResponseEntity<>(sysUserNoticeService.create(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改UserNoticeService")
    @ApiOperation("修改UserNoticeService")
    @PreAuthorize("@el.check('sysUserNotice:edit')")
    public ResponseEntity<Object> update(@Validated @RequestBody SysUserNotice resources){
        sysUserNoticeService.update(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @Log("删除UserNoticeService")
    @ApiOperation("删除UserNoticeService")
    @PreAuthorize("@el.check('sysUserNotice:del')")
    @DeleteMapping
    public ResponseEntity<Object> delete(@RequestBody Long[] ids) {
        sysUserNoticeService.deleteAll(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }
}
