/*
*  Copyright 2019-2020 Zheng Jie
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*  http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*/
package admin.rest;


import admin.annotation.Log;
import admin.modules.system.domain.SystemOpLog;
import admin.modules.system.service.SystemOpLogService;
import admin.modules.system.service.dto.SystemOpLogQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
* @website https://el-admin.vip
* @author wl
* @date 2020-07-19
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "SystemOpLogService管理")
@RequestMapping("/api/systemOpLog")
public class SystemOpLogController {

    private final SystemOpLogService systemOpLogService;

    @Log("导出数据")
    @ApiOperation("导出数据")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('systemOpLog:list')")
    public void download(HttpServletResponse response, SystemOpLogQueryCriteria criteria) throws IOException {
        systemOpLogService.download(systemOpLogService.queryAll(criteria), response);
    }

    @GetMapping
    @ApiOperation("查询SystemOpLogService")
    @PreAuthorize("@el.check('systemOpLog:list')")
    public ResponseEntity<Object> query(SystemOpLogQueryCriteria criteria, Pageable pageable){
        return new ResponseEntity<>(systemOpLogService.queryAll(criteria,pageable),HttpStatus.OK);
    }
    @GetMapping(value = "get")
    @ApiOperation("查询MemberLogService")
    public ResponseEntity<Object> get(Long orderId){
        SystemOpLogQueryCriteria criteria=new SystemOpLogQueryCriteria();
        criteria.setOrderId(orderId);
        return new ResponseEntity<>(systemOpLogService.queryAll(criteria),HttpStatus.OK);
    }
    @PostMapping
    @Log("新增SystemOpLogService")
    @ApiOperation("新增SystemOpLogService")
    @PreAuthorize("@el.check('systemOpLog:add')")
    public ResponseEntity<Object> create(@Validated @RequestBody SystemOpLog resources){
        return new ResponseEntity<>(systemOpLogService.create(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改SystemOpLogService")
    @ApiOperation("修改SystemOpLogService")
    @PreAuthorize("@el.check('systemOpLog:edit')")
    public ResponseEntity<Object> update(@Validated @RequestBody SystemOpLog resources){
        systemOpLogService.update(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @Log("删除SystemOpLogService")
    @ApiOperation("删除SystemOpLogService")
    @PreAuthorize("@el.check('systemOpLog:del')")
    @DeleteMapping
    public ResponseEntity<Object> delete(@RequestBody Long[] ids) {
        systemOpLogService.deleteAll(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }
}
