package admin.rest.analysis;

import admin.annotation.Log;
import admin.annotation.rest.AnonymousGetMapping;
import admin.modules.analysis.service.ApiAnalysisInfoService;
import admin.modules.analysis.service.dto.ApiAnalysisInfoDto;
import admin.modules.analysis.service.dto.ApiAnalysisInfoQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
* @author lj
* @date 2024-12-16
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "ApiAnalysisService管理")
@RequestMapping("/api/apiAnalysisInfo")
public class ApiAnalysisInfoController {

    private final ApiAnalysisInfoService apiAnalysisInfoService;

    @AnonymousGetMapping
    @Log("查询ApiAnalysisService")
    @ApiOperation("查询ApiAnalysisService")
    @PreAuthorize("@el.check('apiAnalysisInfo:list')")
    public ResponseEntity query(ApiAnalysisInfoQueryCriteria query, Pageable pageable){
        return new ResponseEntity<>(apiAnalysisInfoService.queryAll(query,pageable),HttpStatus.OK);
    }

    @GetMapping ("queryPage")
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity queryPage(String startDate,String endDate, Pageable pageable){
        return new ResponseEntity<>(apiAnalysisInfoService.queryPage(startDate,endDate,pageable.getPageNumber(),pageable.getPageSize()),HttpStatus.OK);
    }

    @PostMapping
    @Log("新增ApiAnalysisService")
    @ApiOperation("新增ApiAnalysisService")
    @PreAuthorize("@el.check('apiAnalysisInfo:add')")
    public ResponseEntity create(@Validated @RequestBody ApiAnalysisInfoDto resources){
        return new ResponseEntity<>(apiAnalysisInfoService.insert(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改ApiAnalysisService")
    @ApiOperation("修改ApiAnalysisService")
    @PreAuthorize("@el.check('apiAnalysisInfo:edit')")
    public ResponseEntity update(@Validated @RequestBody ApiAnalysisInfoDto resources){
        apiAnalysisInfoService.updateById(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping
    @Log("删除ApiAnalysisService")
    @ApiOperation("删除ApiAnalysisService")
    @PreAuthorize("@el.check('apiAnalysisInfo:del')")
    public ResponseEntity delete(@RequestBody Set<Long> ids) {
        apiAnalysisInfoService.removeByIds(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /*
    @Log("导出ApiAnalysisService")
    @ApiOperation("导出ApiAnalysisService")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('apiAnalysisInfo:list')")
    public void download(HttpServletResponse response, ApiAnalysisInfoQueryCriteria query) throws IOException {
        apiAnalysisInfoService.download(apiAnalysisInfoService.queryAll(query), response);
    }*/

}
