package admin.rest.analysis;

import admin.annotation.Log;
import admin.modules.analysis.service.CarAnalysisInfoService;
import admin.modules.analysis.service.dto.CarAnalysisInfoDto;
import admin.modules.analysis.service.dto.CarAnalysisInfoQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
* @author lj
* @date 2024-12-16
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "CarAnalysisService管理")
@RequestMapping("/api/carAnalysisInfo")
public class CarAnalysisInfoController {

    private final CarAnalysisInfoService carAnalysisInfoService;

    @GetMapping
    @Log("查询CarAnalysisService")
    @ApiOperation("查询CarAnalysisService")
    @PreAuthorize("@el.check('carAnalysisInfo:list')")
    public ResponseEntity query(CarAnalysisInfoQueryCriteria query, Pageable pageable){
        return new ResponseEntity<>(carAnalysisInfoService.queryAll(query,pageable),HttpStatus.OK);
    }

    @GetMapping ("queryPage")
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity queryPage(String startDate,String endDate, Pageable pageable){
        return new ResponseEntity<>(carAnalysisInfoService.queryPage(startDate,endDate,pageable.getPageNumber(),pageable.getPageSize()),HttpStatus.OK);
    }

    @PostMapping
    @Log("新增CarAnalysisService")
    @ApiOperation("新增CarAnalysisService")
    @PreAuthorize("@el.check('carAnalysisInfo:add')")
    public ResponseEntity create(@Validated @RequestBody CarAnalysisInfoDto resources){
        return new ResponseEntity<>(carAnalysisInfoService.insert(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改CarAnalysisService")
    @ApiOperation("修改CarAnalysisService")
    @PreAuthorize("@el.check('carAnalysisInfo:edit')")
    public ResponseEntity update(@Validated @RequestBody CarAnalysisInfoDto resources){
        carAnalysisInfoService.updateById(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping
    @Log("删除CarAnalysisService")
    @ApiOperation("删除CarAnalysisService")
    @PreAuthorize("@el.check('carAnalysisInfo:del')")
    public ResponseEntity delete(@RequestBody Set<Long> ids) {
        carAnalysisInfoService.removeByIds(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /*
    @Log("导出CarAnalysisService
")
    @ApiOperation("导出CarAnalysisService
")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('carAnalysisInfo:list')")
    public void download(HttpServletResponse response, CarAnalysisInfoQueryCriteria query) throws IOException {
        carAnalysisInfoService.download(carAnalysisInfoService.queryAll(query), response);
    }*/

}
