package admin.rest.analysis;

import admin.annotation.Log;
import admin.modules.analysis.service.DataAnalysisInfoService;
import admin.modules.analysis.service.dto.DataAnalysisInfoDto;
import admin.modules.analysis.service.dto.DataAnalysisInfoQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
* @author lj
* @date 2024-12-16
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "DataAnalysisService管理")
@RequestMapping("/api/dataAnalysisInfo")
public class DataAnalysisInfoController {

    private final DataAnalysisInfoService dataAnalysisInfoService;

    @GetMapping
    @Log("查询DataAnalysisService")
    @ApiOperation("查询DataAnalysisService")
    @PreAuthorize("@el.check('dataAnalysisInfo:list')")
    public ResponseEntity query(DataAnalysisInfoQueryCriteria query, Pageable pageable){
        return new ResponseEntity<>(dataAnalysisInfoService.queryAll(query,pageable),HttpStatus.OK);
    }

    @GetMapping ("queryPage")
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity queryPage(String startDate,String endDate, Pageable pageable){
        return new ResponseEntity<>(dataAnalysisInfoService.queryPage(startDate,endDate,pageable.getPageNumber(),pageable.getPageSize()),HttpStatus.OK);
    }

    @PostMapping
    @Log("新增DataAnalysisService")
    @ApiOperation("新增DataAnalysisService")
    @PreAuthorize("@el.check('dataAnalysisInfo:add')")
    public ResponseEntity create(@Validated @RequestBody DataAnalysisInfoDto resources){
        return new ResponseEntity<>(dataAnalysisInfoService.insert(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改DataAnalysisService")
    @ApiOperation("修改DataAnalysisService")
    @PreAuthorize("@el.check('dataAnalysisInfo:edit')")
    public ResponseEntity update(@Validated @RequestBody DataAnalysisInfoDto resources){
        dataAnalysisInfoService.updateById(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping
    @Log("删除DataAnalysisService")
    @ApiOperation("删除DataAnalysisService")
    @PreAuthorize("@el.check('dataAnalysisInfo:del')")
    public ResponseEntity delete(@RequestBody Set<Long> ids) {
        dataAnalysisInfoService.removeByIds(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /*
    @Log("导出DataAnalysisService")
    @ApiOperation("导出DataAnalysisService")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('dataAnalysisInfo:list')")
    public void download(HttpServletResponse response, DataAnalysisInfoQueryCriteria query) throws IOException {
        dataAnalysisInfoService.download(dataAnalysisInfoService.queryAll(query), response);
    }*/

}
