package admin.rest.analysis;

import admin.annotation.Log;
import admin.annotation.rest.AnonymousGetMapping;
import admin.modules.analysis.service.DeviceAnalysisInfoService;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoDto;
import admin.modules.analysis.service.dto.DeviceAnalysisInfoQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
* @author lj
* @date 2024-12-16
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "DeviceAnalysisService管理")
@RequestMapping("/api/deviceAnalysisInfo")
public class DeviceAnalysisInfoController {

    private final DeviceAnalysisInfoService deviceAnalysisInfoService;

    @AnonymousGetMapping
    @Log("查询DeviceAnalysisService")
    @ApiOperation("查询DeviceAnalysisService")
    @PreAuthorize("@el.check('deviceAnalysisInfo:list')")
    public ResponseEntity query(DeviceAnalysisInfoQueryCriteria query, Pageable pageable){
        return new ResponseEntity<>(deviceAnalysisInfoService.queryAll(query,pageable),HttpStatus.OK);
    }

    @GetMapping ("queryPage")
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity queryPage(String startDate,String endDate, Pageable pageable){
        return new ResponseEntity<>(deviceAnalysisInfoService.queryPage(startDate,endDate,pageable.getPageNumber(),pageable.getPageSize()),HttpStatus.OK);
    }

    @PostMapping
    @Log("新增DeviceAnalysisService")
    @ApiOperation("新增DeviceAnalysisService")
    @PreAuthorize("@el.check('deviceAnalysisInfo:add')")
    public ResponseEntity create(@Validated @RequestBody DeviceAnalysisInfoDto resources){
        return new ResponseEntity<>(deviceAnalysisInfoService.insert(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改DeviceAnalysisService")
    @ApiOperation("修改DeviceAnalysisService")
    @PreAuthorize("@el.check('deviceAnalysisInfo:edit')")
    public ResponseEntity update(@Validated @RequestBody DeviceAnalysisInfoDto resources){
        deviceAnalysisInfoService.updateById(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping
    @Log("删除DeviceAnalysisService")
    @ApiOperation("删除DeviceAnalysisService")
    @PreAuthorize("@el.check('deviceAnalysisInfo:del')")
    public ResponseEntity delete(@RequestBody Set<Long> ids) {
        deviceAnalysisInfoService.removeByIds(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /*
    @Log("导出DeviceAnalysisService
")
    @ApiOperation("导出DeviceAnalysisService
")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('deviceAnalysisInfo:list')")
    public void download(HttpServletResponse response, DeviceAnalysisInfoQueryCriteria query) throws IOException {
        deviceAnalysisInfoService.download(deviceAnalysisInfoService.queryAll(query), response);
    }*/

}
