package admin.rest.analysis;

import admin.annotation.Log;
import admin.modules.analysis.service.MsgAnalysisInfoService;
import admin.modules.analysis.service.dto.MsgAnalysisInfoDto;
import admin.modules.analysis.service.dto.MsgAnalysisInfoQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
* @author lj
* @date 2024-12-16
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "MsgAnalysisService管理")
@RequestMapping("/api/msgAnalysisInfo")
public class MsgAnalysisInfoController {

    private final MsgAnalysisInfoService msgAnalysisInfoService;

    @GetMapping
    @Log("查询MsgAnalysisService")
    @ApiOperation("查询MsgAnalysisService")
    @PreAuthorize("@el.check('msgAnalysisInfo:list')")
    public ResponseEntity query(MsgAnalysisInfoQueryCriteria query, Pageable pageable){
        return new ResponseEntity<>(msgAnalysisInfoService.queryAll(query,pageable),HttpStatus.OK);
    }

    @GetMapping ("queryPage")
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity queryPage(String startDate,String endDate, Pageable pageable){
        return new ResponseEntity<>(msgAnalysisInfoService.queryPage(startDate,endDate,pageable.getPageNumber(),pageable.getPageSize()),HttpStatus.OK);
    }
    @PostMapping
    @Log("新增MsgAnalysisService")
    @ApiOperation("新增MsgAnalysisService")
    @PreAuthorize("@el.check('msgAnalysisInfo:add')")
    public ResponseEntity create(@Validated @RequestBody MsgAnalysisInfoDto resources){
        return new ResponseEntity<>(msgAnalysisInfoService.insert(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改MsgAnalysisService")
    @ApiOperation("修改MsgAnalysisService")
    @PreAuthorize("@el.check('msgAnalysisInfo:edit')")
    public ResponseEntity update(@Validated @RequestBody MsgAnalysisInfoDto resources){
        msgAnalysisInfoService.updateById(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping
    @Log("删除MsgAnalysisService")
    @ApiOperation("删除MsgAnalysisService")
    @PreAuthorize("@el.check('msgAnalysisInfo:del')")
    public ResponseEntity delete(@RequestBody Set<Long> ids) {
        msgAnalysisInfoService.removeByIds(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /*
    @Log("导出MsgAnalysisService
")
    @ApiOperation("导出MsgAnalysisService
")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('msgAnalysisInfo:list')")
    public void download(HttpServletResponse response, MsgAnalysisInfoQueryCriteria query) throws IOException {
        msgAnalysisInfoService.download(msgAnalysisInfoService.queryAll(query), response);
    }*/

}
