package admin.rest.analysis;

import admin.annotation.Log;
import admin.modules.analysis.service.OrderAnalysisInfoService;
import admin.modules.analysis.service.dto.OrderAnalysisInfoDto;
import admin.modules.analysis.service.dto.OrderAnalysisInfoQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
* @author lj
* @date 2024-12-16
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "OrderAnalysisService管理")
@RequestMapping("/api/orderAnalysisInfo")
public class OrderAnalysisInfoController {

    private final OrderAnalysisInfoService orderAnalysisInfoService;

    @GetMapping
    @Log("查询OrderAnalysisService")
    @ApiOperation("查询OrderAnalysisService")
    @PreAuthorize("@el.check('orderAnalysisInfo:list')")
    public ResponseEntity query(OrderAnalysisInfoQueryCriteria query, Pageable pageable){
        return new ResponseEntity<>(orderAnalysisInfoService.queryAll(query,pageable),HttpStatus.OK);
    }

    @PostMapping
    @Log("新增OrderAnalysisService")
    @ApiOperation("新增OrderAnalysisService")
    @PreAuthorize("@el.check('orderAnalysisInfo:add')")
    public ResponseEntity create(@Validated @RequestBody OrderAnalysisInfoDto resources){
        return new ResponseEntity<>(orderAnalysisInfoService.insert(resources),HttpStatus.CREATED);
    }

    @GetMapping ("queryPage")
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity queryPage(String startDate,String endDate, Pageable pageable){
        return new ResponseEntity<>(orderAnalysisInfoService.queryPage(startDate,endDate,pageable.getPageNumber(),pageable.getPageSize()),HttpStatus.OK);
    }

    @PutMapping
    @Log("修改OrderAnalysisService")
    @ApiOperation("修改OrderAnalysisService")
    @PreAuthorize("@el.check('orderAnalysisInfo:edit')")
    public ResponseEntity update(@Validated @RequestBody OrderAnalysisInfoDto resources){
        orderAnalysisInfoService.updateById(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping
    @Log("删除OrderAnalysisService")
    @ApiOperation("删除OrderAnalysisService")
    @PreAuthorize("@el.check('orderAnalysisInfo:del')")
    public ResponseEntity delete(@RequestBody Set<Long> ids) {
        orderAnalysisInfoService.removeByIds(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /*
    @Log("导出OrderAnalysisService
")
    @ApiOperation("导出OrderAnalysisService
")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('orderAnalysisInfo:list')")
    public void download(HttpServletResponse response, OrderAnalysisInfoQueryCriteria query) throws IOException {
        orderAnalysisInfoService.download(orderAnalysisInfoService.queryAll(query), response);
    }*/

}
