package admin.rest.analysis;

import admin.annotation.Log;
import admin.modules.analysis.service.PayAnalysisInfoService;
import admin.modules.analysis.service.dto.PayAnalysisInfoDto;
import admin.modules.analysis.service.dto.PayAnalysisInfoQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
* @author lj
* @date 2024-12-16
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "PayAnalysisService管理")
@RequestMapping("/api/payAnalysisInfo")
public class PayAnalysisInfoController {

    private final PayAnalysisInfoService payAnalysisInfoService;

    @GetMapping
    @Log("查询PayAnalysisService")
    @ApiOperation("查询PayAnalysisService")
    @PreAuthorize("@el.check('payAnalysisInfo:list')")
    public ResponseEntity query(PayAnalysisInfoQueryCriteria query, Pageable pageable){
        return new ResponseEntity<>(payAnalysisInfoService.queryAll(query,pageable),HttpStatus.OK);
    }

    @GetMapping ("queryPage")
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity queryPage(String startDate,String endDate, Pageable pageable){
        return new ResponseEntity<>(payAnalysisInfoService.queryPage(startDate,endDate,pageable.getPageNumber(),pageable.getPageSize()),HttpStatus.OK);
    }


    @PostMapping
    @Log("新增PayAnalysisService")
    @ApiOperation("新增PayAnalysisService")
    @PreAuthorize("@el.check('payAnalysisInfo:add')")
    public ResponseEntity create(@Validated @RequestBody PayAnalysisInfoDto resources){
        return new ResponseEntity<>(payAnalysisInfoService.insert(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改PayAnalysisService")
    @ApiOperation("修改PayAnalysisService")
    @PreAuthorize("@el.check('payAnalysisInfo:edit')")
    public ResponseEntity update(@Validated @RequestBody PayAnalysisInfoDto resources){
        payAnalysisInfoService.updateById(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping
    @Log("删除PayAnalysisService")
    @ApiOperation("删除PayAnalysisService")
    @PreAuthorize("@el.check('payAnalysisInfo:del')")
    public ResponseEntity delete(@RequestBody Set<Long> ids) {
        payAnalysisInfoService.removeByIds(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /*
    @Log("导出PayAnalysisService
")
    @ApiOperation("导出PayAnalysisService
")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('payAnalysisInfo:list')")
    public void download(HttpServletResponse response, PayAnalysisInfoQueryCriteria query) throws IOException {
        payAnalysisInfoService.download(payAnalysisInfoService.queryAll(query), response);
    }*/

}
