package admin.rest.analysis;

import admin.annotation.Log;
import admin.annotation.rest.AnonymousGetMapping;
import admin.modules.analysis.service.PlateIdentifyAnalysisInfoService;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoDto;
import admin.modules.analysis.service.dto.PlateIdentifyAnalysisInfoQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
* @author lj
* @date 2024-12-16
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "PlateIdentifyAnalysisService管理")
@RequestMapping("/api/plateIdentifyAnalysisInfo")
public class PlateIdentifyAnalysisInfoController {

    private final PlateIdentifyAnalysisInfoService plateIdentifyAnalysisInfoService;

    @GetMapping
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity query(PlateIdentifyAnalysisInfoQueryCriteria query, Pageable pageable){
        return new ResponseEntity<>(plateIdentifyAnalysisInfoService.queryAll(query,pageable),HttpStatus.OK);
    }

    @GetMapping ("queryPage")
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity queryPage(String startDate,String endDate, Pageable pageable){
        return new ResponseEntity<>(plateIdentifyAnalysisInfoService.queryPage(startDate,endDate,pageable.getPageNumber(),pageable.getPageSize()),HttpStatus.OK);
    }

    @PostMapping
    @Log("新增PlateIdentifyAnalysisService")
    @ApiOperation("新增PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:add')")
    public ResponseEntity create(@Validated @RequestBody PlateIdentifyAnalysisInfoDto resources){
        return new ResponseEntity<>(plateIdentifyAnalysisInfoService.insert(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改PlateIdentifyAnalysisService")
    @ApiOperation("修改PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:edit')")
    public ResponseEntity update(@Validated @RequestBody PlateIdentifyAnalysisInfoDto resources){
        plateIdentifyAnalysisInfoService.updateById(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping
    @Log("删除PlateIdentifyAnalysisService")
    @ApiOperation("删除PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:del')")
    public ResponseEntity delete(@RequestBody Set<Long> ids) {
        plateIdentifyAnalysisInfoService.removeByIds(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /*
    @Log("导出PlateIdentifyAnalysisService
")
    @ApiOperation("导出PlateIdentifyAnalysisService
")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public void download(HttpServletResponse response, PlateIdentifyAnalysisInfoQueryCriteria query) throws IOException {
        plateIdentifyAnalysisInfoService.download(plateIdentifyAnalysisInfoService.queryAll(query), response);
    }*/

}
