package admin.rest.analysis;

import admin.annotation.Log;
import admin.modules.analysis.service.PushAnalysisInfoService;
import admin.modules.analysis.service.dto.PushAnalysisInfoDto;
import admin.modules.analysis.service.dto.PushAnalysisInfoQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

/**
* @author lj
* @date 2024-12-16
**/
@RestController
@RequiredArgsConstructor
@Api(tags = "PushAnalysisService管理")
@RequestMapping("/api/pushAnalysisInfo")
public class  PushAnalysisInfoController {

    private final PushAnalysisInfoService pushAnalysisInfoService;

    @GetMapping
    @Log("查询PushAnalysisService")
    @ApiOperation("查询PushAnalysisService")
    @PreAuthorize("@el.check('pushAnalysisInfo:list')")
    public ResponseEntity query(PushAnalysisInfoQueryCriteria query, Pageable pageable){
        return new ResponseEntity<>(pushAnalysisInfoService.queryAll(query,pageable),HttpStatus.OK);
    }

    @GetMapping ("queryPage")
    @Log("查询PlateIdentifyAnalysisService")
    @ApiOperation("查询PlateIdentifyAnalysisService")
    @PreAuthorize("@el.check('plateIdentifyAnalysisInfo:list')")
    public ResponseEntity queryPage(String startDate,String endDate, Pageable pageable){
        return new ResponseEntity<>(pushAnalysisInfoService.queryPage(startDate,endDate,pageable.getPageNumber(),pageable.getPageSize()),HttpStatus.OK);
    }
    @PostMapping
    @Log("新增PushAnalysisService")
    @ApiOperation("新增PushAnalysisService")
    @PreAuthorize("@el.check('pushAnalysisInfo:add')")
    public ResponseEntity create(@Validated @RequestBody PushAnalysisInfoDto resources){
        return new ResponseEntity<>(pushAnalysisInfoService.insert(resources),HttpStatus.CREATED);
    }

    @PutMapping
    @Log("修改PushAnalysisService")
    @ApiOperation("修改PushAnalysisService")
    @PreAuthorize("@el.check('pushAnalysisInfo:edit')")
    public ResponseEntity update(@Validated @RequestBody PushAnalysisInfoDto resources){
        pushAnalysisInfoService.updateById(resources);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping
    @Log("删除PushAnalysisService")
    @ApiOperation("删除PushAnalysisService")
    @PreAuthorize("@el.check('pushAnalysisInfo:del')")
    public ResponseEntity delete(@RequestBody Set<Long> ids) {
        pushAnalysisInfoService.removeByIds(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /*
    @Log("导出PushAnalysisService
")
    @ApiOperation("导出PushAnalysisService
")
    @GetMapping(value = "/download")
    @PreAuthorize("@el.check('pushAnalysisInfo:list')")
    public void download(HttpServletResponse response, PushAnalysisInfoQueryCriteria query) throws IOException {
        pushAnalysisInfoService.download(pushAnalysisInfoService.queryAll(query), response);
    }*/

}
