package admin.rest.module;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class UserSyncReq {
    @ApiModelProperty(value = "msgId")
    private String msgId;

    @ApiModelProperty(value = "用户信息列表")
    private List<UserVO> users;

    @Data
    public static class UserVO{
        @ApiModelProperty(value = "操作类型 CREATE,表示新增 UPDATE,表示修改 DELETE,表示删除")
        private String optType;

        @ApiModelProperty(value = "用户id")
        private Long userId;

        @ApiModelProperty(value = "用户名")
        private String username;

        @ApiModelProperty(value = "用户密码")
        private String password;

        @ApiModelProperty(value = "是否激活状态")
        private Boolean isActive;

        @ApiModelProperty(value = "创建者id")
        private Long creator;

        @ApiModelProperty(value = "修改者id")
        private Long editor;

        @ApiModelProperty(value = "用户真实名称")
        private String realName;

        @ApiModelProperty(value = "用户email")
        private String email;

        @ApiModelProperty(value = "用户手机")
        private String phoneNumber;
    }
}
