package admin.utils;

public enum ApiResponseCode {
    SUCCESS("0", "成功"),
    FAILURE("9000", "处理失败"),
    WAIT_CHECK("1001", "已认证，待处理"),
    WAIT_PAY("1002", "待充值"),
    DATA_EMPTY("9995", "数据为空"),
    DB_ERROR("9996", "数据库错误"),
    PARAM_NULL("9997", "参数为空"),
    PARAM_ERROR("9998", "参数错误"),
    SYSTEM_ERROR("9999", "系统异常"),
    USER_NOT_LOGIN("9","已在其他设备登录！"),
    USER_NO_BIND_Mobile("11","未绑定手机号码！"),
    WAIT_RESULT("99","等待结果，请查询交易流水信息"),
    MAS_SUCCESS("1", "成功"),
    MAS_MOBILES_NULL("102", "mobiles为空"),
    MAS_MOBILES_EMPTY("103", "mobiles为空数组"),
    MAS_MOBILES_CHECK("104", "mobiles含有非法号码"),
    MAS_AUTHENTICATION_CHECK("105", "未进行身份认证或认证失败"),
    MAS_SIGN_NULL("106", "sign为空"),
    MAS_OTHER_ERROR("107", "其它错误"),
    MAS_MOBILES_REPEAT("109","mobiles含有重复号码"),
    MAS_MOBILES_MAX("11","mobiles中号码数量超限（>5000），应≤5000"),
    MAS_THREAD_POOL_BUSY("112","线程池忙");

    private String code;
    private String message;

    private ApiResponseCode(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public ApiResponseCode setMessage(String message) {
        this.message = message;
        return this;
    }
    public static String getMessage(String code) {
        for (ApiResponseCode value : ApiResponseCode.values()) {
            if (value.getCode().equals(code)) {
                return value.getMessage();
            }
        }
        return null;
    }
}
